
export const dollarsToCents = (dollars: number): number => Math.round(dollars * 100);

export const centsToDollars = (cents: number): number => cents / 100;

export const formatAud = (cents: number): string => {
  return new Intl.NumberFormat('en-AU', {
    style: 'currency',
    currency: 'AUD',
  }).format(centsToDollars(cents));
};
