
import React from 'react';
import { Link } from 'react-router-dom';

const HomePage: React.FC = () => {
  return (
    <div className="flex flex-col">
      <section className="bg-indigo-600 py-24 px-4 text-white">
        <div className="max-w-7xl mx-auto text-center">
          <h1 className="text-4xl md:text-6xl font-extrabold mb-6 tracking-tight">
            Find the Right Mediator <br className="hidden md:block" /> For Your Dispute
          </h1>
          <p className="text-xl md:text-2xl text-indigo-100 mb-10 max-w-3xl mx-auto font-light">
            Fast, fair, and affordable conflict resolution starts here. Browse verified specialists across Australia.
          </p>
          <div className="flex flex-col sm:flex-row justify-center gap-4">
            <Link 
              to="/mediators" 
              className="bg-white text-indigo-600 px-8 py-4 rounded-lg font-bold text-lg hover:bg-slate-100 transition-all shadow-xl"
            >
              General Mediation
            </Link>
            <Link 
              to="/fdr/start" 
              className="bg-indigo-500 text-white px-8 py-4 rounded-lg font-bold text-lg hover:bg-indigo-400 transition-all border border-indigo-400 shadow-xl"
            >
              Family Law (FDR) Path
            </Link>
          </div>
        </div>
      </section>

      {/* Specialty Path Section */}
      <section className="py-20 px-4 bg-white">
        <div className="max-w-7xl mx-auto">
          <div className="grid md:grid-cols-2 gap-12 items-center">
             <div className="space-y-6">
                <span className="bg-indigo-100 text-indigo-700 px-3 py-1 rounded-full text-xs font-bold uppercase tracking-widest">Specialist Workflow</span>
                <h2 className="text-4xl font-black text-slate-900 leading-tight">Professional FDR Practice</h2>
                <p className="text-slate-600 leading-relaxed text-lg">
                  Family Dispute Resolution requires a higher standard of gatekeeping and safety assessment. Our platform follows a 4-stage compliance workflow.
                </p>
                <div className="space-y-4">
                  {[
                    {t: 'Administrative Screening', d: 'Safety first. Junior FDRP gatekeeping before any contact.'},
                    {t: '3-Mediator Proposal', d: 'Neutral selection model ensuring party agency.'},
                    {t: 'Substantive Pre-Mediation', d: 'In-depth assessment by selected practitioners.'}
                  ].map((f, i) => (
                    <div key={i} className="flex gap-4">
                      <div className="w-6 h-6 bg-indigo-600 text-white rounded-full flex items-center justify-center text-xs font-bold flex-shrink-0 mt-1">{i+1}</div>
                      <div>
                        <h4 className="font-bold text-slate-900">{f.t}</h4>
                        <p className="text-sm text-slate-500">{f.d}</p>
                      </div>
                    </div>
                  ))}
                </div>
                <Link to="/fdr/start" className="inline-block bg-indigo-600 text-white px-8 py-3 rounded-lg font-bold hover:bg-indigo-700 transition-all">Start FDR Workflow</Link>
             </div>
             <div className="bg-slate-50 rounded-3xl p-8 border border-slate-200 shadow-inner">
                <div className="aspect-video bg-white rounded-2xl shadow-sm border p-6 flex flex-col justify-between">
                   <div className="flex justify-between items-start">
                      <div className="w-12 h-12 bg-indigo-50 rounded-xl flex items-center justify-center text-indigo-600">
                         <svg className="h-6 w-6" fill="currentColor" viewBox="0 0 20 20"><path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" /></svg>
                      </div>
                      <span className="text-[10px] font-bold text-slate-400 uppercase tracking-widest">FDR Compliant</span>
                   </div>
                   <div>
                      <h4 className="text-xl font-bold mb-1">s60I Certificate Pathway</h4>
                      <p className="text-slate-500 text-sm">Lawful issuance of certificates supported through every exit point of our system.</p>
                   </div>
                </div>
             </div>
          </div>
        </div>
      </section>

      <section className="py-20 px-4 bg-slate-50 border-y border-slate-200">
        <div className="max-w-7xl mx-auto text-center mb-16">
          <h2 className="text-3xl font-bold">Standard Resolution Resources</h2>
        </div>
        <div className="max-w-7xl mx-auto grid md:grid-cols-3 gap-8">
            <Link to="/info/how-to-engage" className="bg-white p-8 rounded-2xl shadow-sm border border-slate-200 hover:border-indigo-400 hover:shadow-md transition-all group">
                <h3 className="text-lg font-bold mb-2">How to Engage</h3>
                <p className="text-slate-500 text-sm mb-4">Practical guide to starting the process.</p>
                <span className="text-indigo-600 text-sm font-bold">Read Guide →</span>
            </Link>
            <Link to="/info/when-to-use" className="bg-white p-8 rounded-2xl shadow-sm border border-slate-200 hover:border-indigo-400 hover:shadow-md transition-all group">
                <h3 className="text-lg font-bold mb-2">When to use Mediation?</h3>
                <p className="text-slate-500 text-sm mb-4">Understanding timing and benefits.</p>
                <span className="text-indigo-600 text-sm font-bold">Read Guide →</span>
            </Link>
            <Link to="/info/preparation" className="bg-white p-8 rounded-2xl shadow-sm border border-slate-200 hover:border-indigo-400 hover:shadow-md transition-all group">
                <h3 className="text-lg font-bold mb-2">Preparing for Success</h3>
                <p className="text-slate-500 text-sm mb-4">Tips for readiness and documentation.</p>
                <span className="text-indigo-600 text-sm font-bold">Read Guide →</span>
            </Link>
        </div>
      </section>
    </div>
  );
};

export default HomePage;
