import React, { useState } from 'react';
import { AuthService } from '../../services/AuthService';
import MediatorAvailabilityManager from './MediatorAvailabilityManager';
import OperatingHoursManager from './OperatingHoursManager';

const MediatorAvailabilityPage: React.FC = () => {
  const user = AuthService.getCurrentUser();
  const [activeTab, setActiveTab] = useState<'hours' | 'exceptions'>('hours');

  if (!user?.profileId) {
    return (
      <div className="max-w-7xl mx-auto px-4 py-12">
        <div className="text-center">
          <p className="text-slate-600">Please complete your profile first.</p>
        </div>
      </div>
    );
  }

  return (
    <div className="max-w-4xl mx-auto px-4 py-12">
      <div className="mb-8">
        <h1 className="text-3xl font-bold text-slate-900">Manage Availability</h1>
        <p className="text-slate-600 mt-2">
          Set your regular hours and mark exceptions
        </p>
      </div>

      {/* Tabs */}
      <div className="bg-white rounded-lg shadow mb-6">
        <div className="border-b border-gray-200">
          <nav className="flex -mb-px">
            <button
              onClick={() => setActiveTab('hours')}
              className={`py-4 px-8 text-sm font-medium border-b-2 ${
                activeTab === 'hours'
                  ? 'border-indigo-600 text-indigo-600'
                  : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'
              }`}
            >
              ⏰ Operating Hours
            </button>
            <button
              onClick={() => setActiveTab('exceptions')}
              className={`py-4 px-8 text-sm font-medium border-b-2 ${
                activeTab === 'exceptions'
                  ? 'border-indigo-600 text-indigo-600'
                  : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'
              }`}
            >
              🚫 Exceptions (Holidays/Illness)
            </button>
          </nav>
        </div>
      </div>

      {/* Tab Content */}
      {activeTab === 'hours' && <OperatingHoursManager mediatorId={user.profileId} />}
      {activeTab === 'exceptions' && <MediatorAvailabilityManager mediatorId={user.profileId} />}
    </div>
  );
};

export default MediatorAvailabilityPage;
