
import React, { useEffect } from 'react';
import { Link } from 'react-router-dom';

const AboutUsPage: React.FC = () => {
  useEffect(() => {
    window.scrollTo(0, 0);
  }, []);

  return (
    <div className="bg-slate-50 min-h-screen">
      <div className="bg-indigo-600 py-16 text-white px-4">
        <div className="max-w-4xl mx-auto text-center">
          <h1 className="text-3xl md:text-5xl font-extrabold tracking-tight mb-4 uppercase">About Us</h1>
          <p className="text-indigo-100 text-lg md:text-xl font-light max-w-2xl mx-auto leading-relaxed">
            Making mediation accessible, transparent, and efficient for everyone.
          </p>
        </div>
      </div>

      <div className="max-w-4xl mx-auto px-4 py-12">
        <div className="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
          <div className="p-8 md:p-12 space-y-8">
            <section className="space-y-4">
              <p className="text-slate-700 text-lg leading-relaxed">
                This platform was created to make mediation accessible, transparent, and efficient.
              </p>
            </section>

            <section className="space-y-6">
              <h2 className="text-2xl font-bold text-slate-900 border-b pb-2">Our Mission</h2>
              <div className="grid sm:grid-cols-3 gap-6">
                <div className="bg-indigo-50 p-6 rounded-xl border border-indigo-100 flex flex-col items-center text-center">
                  <div className="w-10 h-10 bg-indigo-600 text-white rounded-full flex items-center justify-center mb-4 font-bold">1</div>
                  <h3 className="font-bold text-indigo-700 mb-2">Resolution</h3>
                  <p className="text-sm text-slate-600">Resolving conflicts early.</p>
                </div>
                <div className="bg-indigo-50 p-6 rounded-xl border border-indigo-100 flex flex-col items-center text-center">
                  <div className="w-10 h-10 bg-indigo-600 text-white rounded-full flex items-center justify-center mb-4 font-bold">2</div>
                  <h3 className="font-bold text-indigo-700 mb-2">Engagement</h3>
                  <p className="text-sm text-slate-600">Empowered informed choices.</p>
                </div>
                <div className="bg-indigo-50 p-6 rounded-xl border border-indigo-100 flex flex-col items-center text-center">
                  <div className="w-10 h-10 bg-indigo-600 text-white rounded-full flex items-center justify-center mb-4 font-bold">3</div>
                  <h3 className="font-bold text-indigo-700 mb-2">Standards</h3>
                  <p className="text-sm text-slate-600">Professional transparency.</p>
                </div>
              </div>
            </section>

            <div className="pt-12 text-center">
              <Link 
                to="/mediators" 
                className="bg-indigo-600 text-white px-10 py-4 rounded-xl font-bold text-lg hover:bg-indigo-700 transition-all shadow-xl active:scale-95 inline-block"
              >
                Find Your Mediator
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default AboutUsPage;
