
import React, { useEffect } from 'react';
import { Link } from 'react-router-dom';

const InfoHowToEngage: React.FC = () => {
  useEffect(() => {
    window.scrollTo(0, 0);
  }, []);

  return (
    <div className="bg-slate-50 min-h-screen">
      <div className="bg-indigo-600 py-16 text-white px-4">
        <div className="max-w-4xl mx-auto">
          <Link to="/" className="text-white/70 hover:text-white flex items-center gap-2 mb-8 text-sm font-medium transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
              <path fillRule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clipRule="evenodd" />
            </svg>
            Back to Home
          </Link>
          <h1 className="text-3xl md:text-5xl font-extrabold tracking-tight mb-4 uppercase">How to Engage a Mediator</h1>
          <p className="text-indigo-100 text-lg md:text-xl font-light max-w-2xl leading-relaxed">
            Selecting the right expert and starting your resolution journey.
          </p>
        </div>
      </div>

      <div className="max-w-4xl mx-auto px-4 py-12">
        <div className="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
          <div className="p-8 md:p-12 prose prose-indigo max-w-none">
            <div className="mb-12 border-b pb-8">
              <h2 className="text-xl font-bold text-slate-900 mb-4">Introduction</h2>
              <p className="text-slate-600 leading-relaxed text-lg">
                Engaging a mediator is an important step in resolving a dispute constructively.
              </p>
            </div>

            <div className="space-y-16">
              <section>
                <div className="flex items-center gap-3 mb-6">
                  <div className="w-8 h-8 bg-indigo-600 text-white rounded-full flex items-center justify-center font-bold">1</div>
                  <h2 className="text-2xl font-bold text-slate-900">What Is Mediation?</h2>
                </div>
                <p className="text-slate-600 mb-6 leading-relaxed">
                  Confidential and structured negotiation assisted by a neutral third party.
                </p>
              </section>

              <section>
                <div className="flex items-center gap-3 mb-6">
                  <div className="w-8 h-8 bg-indigo-600 text-white rounded-full flex items-center justify-center font-bold">2</div>
                  <h2 className="text-2xl font-bold text-slate-900">Accreditation (AMDRAS)</h2>
                </div>
                <div className="bg-indigo-600 text-white p-6 rounded-xl shadow-lg border border-indigo-500">
                  <h4 className="font-bold mb-2">Australian Standards</h4>
                  <p className="text-sm leading-relaxed opacity-90">
                    Many mediators are accredited under the AMDRAS accreditation system, ensuring high standards and professional insurance.
                  </p>
                </div>
              </section>

              <div className="bg-indigo-700 text-white p-10 rounded-3xl shadow-2xl text-center">
                <h3 className="text-2xl font-bold mb-4">Ready to Start?</h3>
                <Link 
                  to="/mediators" 
                  className="inline-block bg-white text-indigo-600 px-10 py-5 rounded-2xl font-bold text-lg hover:bg-slate-50 transition-all shadow-xl active:scale-95"
                >
                  Find a Mediator
                </Link>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default InfoHowToEngage;
