
import React, { useEffect } from 'react';
import { Link } from 'react-router-dom';

const InfoPreparation: React.FC = () => {
  useEffect(() => {
    window.scrollTo(0, 0);
  }, []);

  return (
    <div className="bg-slate-50 min-h-screen">
      <div className="bg-indigo-700 py-16 text-white px-4">
        <div className="max-w-4xl mx-auto">
          <Link to="/" className="text-indigo-200 hover:text-white flex items-center gap-2 mb-8 text-sm font-medium transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
              <path fillRule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clipRule="evenodd" />
            </svg>
            Back to Home
          </Link>
          <h1 className="text-3xl md:text-5xl font-extrabold tracking-tight mb-4 uppercase">Preparing for Mediation</h1>
          <p className="text-indigo-100 text-lg md:text-xl font-light max-w-2xl leading-relaxed">
            Essential steps to ensure you are ready—practically, emotionally, and technically.
          </p>
        </div>
      </div>

      <div className="max-w-4xl mx-auto px-4 py-12">
        <div className="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
          <div className="p-8 md:p-12 prose prose-indigo max-w-none">
            
            <section className="mb-16">
              <h2 className="text-3xl font-bold text-slate-900 mb-8 border-b pb-4">Essential Preparation</h2>
              <div className="space-y-12">
                <div>
                  <h3 className="text-xl font-bold text-indigo-900 mb-4">Documents and Information to Gather</h3>
                  <p className="text-slate-600 mb-4">Having the right information at your fingertips prevents delays. Prepare a folder containing:</p>
                  <ul className="grid md:grid-cols-2 gap-3 text-sm text-slate-600 list-none p-0">
                    <li className="bg-slate-50 p-4 rounded-xl border border-slate-100 flex items-start gap-3">
                      <span className="text-green-500 font-bold">✓</span> Relevant contracts, emails, or text messages.
                    </li>
                    <li className="bg-slate-50 p-4 rounded-xl border border-slate-100 flex items-start gap-3">
                      <span className="text-green-500 font-bold">✓</span> Financial statements or property valuations.
                    </li>
                    <li className="bg-slate-50 p-4 rounded-xl border border-slate-100 flex items-start gap-3">
                      <span className="text-green-500 font-bold">✓</span> Timelines of key events related to the dispute.
                    </li>
                    <li className="bg-slate-50 p-4 rounded-xl border border-slate-100 flex items-start gap-3">
                      <span className="text-green-500 font-bold">✓</span> Any existing legal documents or court orders.
                    </li>
                  </ul>
                </div>

                <div>
                  <h3 className="text-xl font-bold text-indigo-900 mb-4">Setting Goals and Priorities</h3>
                  <p className="text-slate-600 mb-4">Know what you want, but also know what you need. Differentiate between your "must-haves" and your "nice-to-haves."</p>
                </div>

                <div className="bg-indigo-50 p-6 rounded-2xl border border-indigo-100">
                  <h3 className="text-xl font-bold text-indigo-900 mb-4">Understanding BATNA/WATNA</h3>
                  <div className="space-y-4 text-sm text-indigo-800">
                    <p><strong>BATNA (Best Alternative to a Negotiated Agreement):</strong> What is the best outcome you can expect if mediation fails? (e.g., winning at court).</p>
                    <p><strong>WATNA (Worst Alternative to a Negotiated Agreement):</strong> What is the worst-case scenario if you don't settle? (e.g., losing at court and paying high legal fees).</p>
                    <p className="font-medium italic">Knowing these helps you evaluate whether a settlement offer is actually a "good deal."</p>
                  </div>
                </div>

                <div>
                  <h3 className="text-xl font-bold text-indigo-900 mb-4">Emotional and Practical Readiness</h3>
                  <p className="text-slate-600 leading-relaxed">
                    Mediation can be emotionally taxing. Ensure you have a support system, take breaks during the session if needed, and arrive with an open mind. Practically, ensure you have cleared your schedule for the entire estimated duration of the session.
                  </p>
                </div>
              </div>
            </section>

            <section className="mb-16">
              <h2 className="text-3xl font-bold text-slate-900 mb-8 border-b pb-4">Online vs In-Person Mediation</h2>
              <div className="space-y-8">
                <div className="grid md:grid-cols-2 gap-8">
                  <div>
                    <h3 className="font-bold text-slate-900 mb-3 uppercase text-xs tracking-widest">Advantages of Online</h3>
                    <ul className="space-y-2 text-sm text-slate-600">
                      <li>• <strong>Convenience:</strong> Mediate from the comfort of your own space.</li>
                      <li>• <strong>Cost:</strong> No travel or room hire costs.</li>
                      <li>• <strong>Safety:</strong> Provides a sense of security for parties with high conflict.</li>
                    </ul>
                  </div>
                  <div>
                    <h3 className="font-bold text-slate-900 mb-3 uppercase text-xs tracking-widest">In-Person Considerations</h3>
                    <ul className="space-y-2 text-sm text-slate-600">
                      <li>• <strong>Body Language:</strong> Easier to read non-verbal cues.</li>
                      <li>• <strong>Focus:</strong> Parties are often more focused in a neutral, dedicated room.</li>
                      <li>• <strong>Room Hire:</strong> May incur additional costs.</li>
                    </ul>
                  </div>
                </div>

                <div className="bg-slate-900 text-white p-8 rounded-2xl shadow-lg">
                  <h3 className="text-xl font-bold mb-4 flex items-center gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" className="h-5 w-5 text-indigo-400" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                      <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z" />
                    </svg>
                    Confidentiality & Technology
                  </h3>
                  <p className="text-slate-400 text-sm leading-relaxed mb-4">
                    For online mediation, ensure you are in a private, quiet room where you won't be overheard. You must use a secure platform (usually provided by the mediator) and have a stable internet connection.
                  </p>
                  <p className="text-slate-400 text-sm leading-relaxed italic">
                    All medi8 mediators offer secure environments, whether physical or digital.
                  </p>
                </div>
              </div>
            </section>

            <div className="bg-indigo-700 text-white p-10 rounded-3xl shadow-2xl text-center">
              <h3 className="text-2xl font-bold mb-4">Ready to Resolve?</h3>
              <p className="text-indigo-100 mb-8 max-w-xl mx-auto leading-relaxed text-lg">
                Preparation is half the battle. Now that you know what to expect, find the mediator who fits your needs.
              </p>
              <Link 
                to="/mediators" 
                className="inline-block bg-white text-indigo-700 px-10 py-5 rounded-2xl font-bold text-lg hover:bg-indigo-50 transition-all shadow-xl active:scale-95"
              >
                Start Searching Now
              </Link>
            </div>

          </div>
        </div>
      </div>
    </div>
  );
};

export default InfoPreparation;
