
import React, { useEffect } from 'react';
import { Link } from 'react-router-dom';

const InfoWhenToUse: React.FC = () => {
  useEffect(() => {
    window.scrollTo(0, 0);
  }, []);

  return (
    <div className="bg-slate-50 min-h-screen">
      <div className="bg-indigo-700 py-16 text-white px-4">
        <div className="max-w-4xl mx-auto">
          <Link to="/" className="text-indigo-200 hover:text-white flex items-center gap-2 mb-8 text-sm font-medium transition-colors">
            <svg xmlns="http://www.w3.org/2000/svg" className="h-4 w-4" viewBox="0 0 20 20" fill="currentColor">
              <path fillRule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z" clipRule="evenodd" />
            </svg>
            Back to Home
          </Link>
          <h1 className="text-3xl md:text-5xl font-extrabold tracking-tight mb-4 uppercase">When should you use Mediation?</h1>
          <p className="text-indigo-100 text-lg md:text-xl font-light max-w-2xl leading-relaxed">
            Understanding the timing, context, and benefits of choosing mediation over litigation.
          </p>
        </div>
      </div>

      <div className="max-w-4xl mx-auto px-4 py-12">
        <div className="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
          <div className="p-8 md:p-12 prose prose-indigo max-w-none">
            
            <section className="mb-12">
              <div className="flex items-center gap-3 mb-6">
                <div className="w-8 h-8 bg-indigo-100 text-indigo-600 rounded-full flex items-center justify-center font-bold">A</div>
                <h2 className="text-2xl font-bold text-slate-900">Timing: Early vs Late Mediation</h2>
              </div>
              <div className="space-y-4 text-slate-600">
                <p>
                  <strong>Early Mediation:</strong> Engaging a mediator shortly after a dispute arises can prevent conflict from escalating. It minimizes legal costs, reduces emotional stress, and preserves relationships that might otherwise be destroyed by long-term hostility.
                </p>
                <p>
                  <strong>Late Mediation:</strong> While mediation is most effective early, it can still be used late in a process—even on the "steps of the court." It remains a viable way to avoid the final costs and unpredictability of a court trial.
                </p>
              </div>
            </section>

            <section className="mb-12">
              <div className="flex items-center gap-3 mb-6">
                <div className="w-8 h-8 bg-indigo-100 text-indigo-600 rounded-full flex items-center justify-center font-bold">B</div>
                <h2 className="text-2xl font-bold text-slate-900">Before Court or Tribunal</h2>
              </div>
              <p className="text-slate-600 mb-4">
                In many jurisdictions, mediation is a prerequisite or strongly encouraged before a matter can proceed to a formal hearing.
              </p>
              <ul className="space-y-3 text-slate-600 pl-4 border-l-4 border-indigo-200">
                <li><strong>Pre-filing:</strong> Resolve the matter before any documents are lodged with a court.</li>
                <li><strong>During Proceedings:</strong> Courts often refer matters to mediation to encourage settlement before trial.</li>
              </ul>
            </section>

            <section className="mb-12">
              <div className="flex items-center gap-3 mb-6">
                <div className="w-8 h-8 bg-indigo-100 text-indigo-600 rounded-full flex items-center justify-center font-bold">C</div>
                <h2 className="text-2xl font-bold text-slate-900">Mandatory vs Voluntary Mediation</h2>
              </div>
              <div className="grid md:grid-cols-2 gap-6">
                <div className="p-5 bg-slate-50 rounded-xl border border-slate-200">
                  <h3 className="font-bold text-slate-900 mb-2">Mandatory</h3>
                  <p className="text-sm text-slate-600">Some family law and civil matters require a certificate (e.g., Section 60I) from a practitioner showing that a genuine effort was made to mediate before court intervention is granted.</p>
                </div>
                <div className="p-5 bg-slate-50 rounded-xl border border-slate-200">
                  <h3 className="font-bold text-slate-900 mb-2">Voluntary</h3>
                  <p className="text-sm text-slate-600">Parties can agree to mediate at any time. Voluntary participation often leads to higher satisfaction levels and more durable agreements because parties are personally invested in the outcome.</p>
                </div>
              </div>
            </section>

            <section className="mb-12">
              <div className="flex items-center gap-3 mb-6">
                <div className="w-8 h-8 bg-indigo-100 text-indigo-600 rounded-full flex items-center justify-center font-bold">D</div>
                <h2 className="text-2xl font-bold text-slate-900">Benefits compared with Litigation</h2>
              </div>
              <div className="overflow-hidden rounded-xl border border-slate-200 shadow-sm">
                <table className="w-full text-left text-sm">
                  <thead className="bg-slate-900 text-white">
                    <tr>
                      <th className="px-4 py-3 font-bold uppercase tracking-wider">Feature</th>
                      <th className="px-4 py-3 font-bold uppercase tracking-wider">Mediation</th>
                      <th className="px-4 py-3 font-bold uppercase tracking-wider">Litigation</th>
                    </tr>
                  </thead>
                  <tbody className="divide-y divide-slate-200 bg-white">
                    <tr>
                      <td className="px-4 py-3 font-bold text-slate-900">Cost</td>
                      <td className="px-4 py-3 text-green-700 font-medium">Lower / Controlled</td>
                      <td className="px-4 py-3 text-red-700 font-medium">High / Escalating</td>
                    </tr>
                    <tr>
                      <td className="px-4 py-3 font-bold text-slate-900">Speed</td>
                      <td className="px-4 py-3 text-slate-600">Weeks / Months</td>
                      <td className="px-4 py-3 text-slate-600">Years</td>
                    </tr>
                    <tr>
                      <td className="px-4 py-3 font-bold text-slate-900">Control</td>
                      <td className="px-4 py-3 text-slate-600">Parties decide</td>
                      <td className="px-4 py-3 text-slate-600">Judge decides</td>
                    </tr>
                    <tr>
                      <td className="px-4 py-3 font-bold text-slate-900">Privacy</td>
                      <td className="px-4 py-3 text-slate-600">Confidential</td>
                      <td className="px-4 py-3 text-slate-600">Public Record</td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </section>

            <div className="bg-indigo-700 text-white p-10 rounded-3xl shadow-2xl text-center mt-16">
              <h3 className="text-2xl font-bold mb-4">Take the First Step</h3>
              <p className="text-indigo-100 mb-8 max-w-xl mx-auto leading-relaxed">
                Whether your participation is mandatory or voluntary, medi8 helps you find the right specialist for your situation.
              </p>
              <Link 
                to="/mediators" 
                className="inline-block bg-white text-indigo-700 px-10 py-5 rounded-2xl font-bold text-lg hover:bg-indigo-50 transition-all shadow-xl active:scale-95"
              >
                Start Searching Now
              </Link>
            </div>

          </div>
        </div>
      </div>
    </div>
  );
};

export default InfoWhenToUse;
