
import React, { useEffect } from 'react';
import { Link } from 'react-router-dom';

const TermsOfUsePage: React.FC = () => {
  useEffect(() => {
    window.scrollTo(0, 0);
  }, []);

  return (
    <div className="bg-slate-50 min-h-screen">
      {/* Hero Header */}
      <div className="bg-slate-900 py-16 text-white px-4">
        <div className="max-w-4xl mx-auto text-center">
          <h1 className="text-3xl md:text-5xl font-extrabold tracking-tight mb-4 uppercase">Terms of Use</h1>
          <p className="text-slate-400 text-lg md:text-xl font-light max-w-2xl mx-auto leading-relaxed">
            Please read these terms carefully before using the medi8 platform.
          </p>
        </div>
      </div>

      <div className="max-w-4xl mx-auto px-4 py-12">
        <div className="bg-white rounded-2xl shadow-sm border border-slate-200 overflow-hidden">
          <div className="p-8 md:p-12 space-y-12 prose prose-slate max-w-none">
            
            <section>
              <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                <span className="text-indigo-600">1.</span> Platform Role
              </h2>
              <div className="text-slate-600 space-y-4">
                <p>This platform is a booking marketplace only. We:</p>
                <ul className="list-disc pl-5 space-y-2">
                  <li>Facilitate discovery and booking of mediators</li>
                  <li>Process payments via third-party providers</li>
                  <li>Do not provide mediation services ourselves</li>
                </ul>
                <p className="font-medium text-slate-800 italic">No agency, partnership, or employment relationship is created.</p>
              </div>
            </section>

            <section>
              <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                <span className="text-indigo-600">2.</span> No Legal Advice
              </h2>
              <p className="text-slate-600">
                Information on this platform is general in nature and does not constitute legal advice. Users should obtain independent professional advice where appropriate.
              </p>
            </section>

            <section>
              <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                <span className="text-indigo-600">3.</span> Mediator Engagement
              </h2>
              <div className="text-slate-600 space-y-4">
                <p>When you book a mediator:</p>
                <ul className="list-disc pl-5 space-y-2">
                  <li>You enter into a direct agreement with the mediator</li>
                  <li>The mediator is responsible for their services, fees, and conduct</li>
                  <li>Any dispute regarding mediation services must be addressed with the mediator</li>
                </ul>
              </div>
            </section>

            <section className="bg-slate-50 p-8 rounded-2xl border border-slate-100">
              <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                <span className="text-indigo-600">4.</span> Fees, Payments & Stripe
              </h2>
              <div className="text-slate-600 space-y-4">
                <p>Payments are processed securely via Stripe. By using this platform, you agree to:</p>
                <ul className="list-disc pl-5 space-y-2">
                  <li>Stripe’s Services Agreement</li>
                  <li>Applicable payment processing fees</li>
                  <li>Refund and cancellation policies disclosed at booking</li>
                </ul>
                <p className="text-sm font-semibold text-slate-500">We do not store full payment card details.</p>
              </div>
            </section>

            <section>
              <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                <span className="text-indigo-600">5.</span> User Obligations
              </h2>
              <div className="text-slate-600 space-y-4">
                <p>Users agree to:</p>
                <ul className="list-disc pl-5 space-y-2">
                  <li>Provide accurate information</li>
                  <li>Use the platform lawfully</li>
                  <li>Not misuse or interfere with platform services</li>
                </ul>
              </div>
            </section>

            <section>
              <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                <span className="text-indigo-600">6.</span> Confidentiality and Mediation
              </h2>
              <div className="text-slate-600 space-y-4">
                <p>Mediation is generally confidential, but confidentiality obligations arise from:</p>
                <ul className="list-disc pl-5 space-y-2">
                  <li>The mediator’s agreement</li>
                  <li>Applicable law</li>
                  <li>Any mediation agreement entered into</li>
                </ul>
                <p className="text-sm italic">The platform is not responsible for confidentiality breaches arising during mediation.</p>
              </div>
            </section>

            <section>
              <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                <span className="text-indigo-600">7.</span> Limitation of Liability
              </h2>
              <div className="text-slate-600 space-y-4">
                <p>To the extent permitted by law, we exclude liability for:</p>
                <ul className="list-disc pl-5 space-y-2">
                  <li>Actions or omissions of mediators</li>
                  <li>Outcomes of mediations</li>
                  <li>Losses arising from use of the platform</li>
                </ul>
                <p className="font-medium text-slate-800">Nothing excludes rights under Australian Consumer Law.</p>
              </div>
            </section>

            <section className="pt-8 border-t border-slate-100">
              <h2 className="text-2xl font-bold text-slate-900 mb-4 flex items-center gap-3">
                <span className="text-indigo-600">8.</span> Governing Law
              </h2>
              <p className="text-slate-600">
                These Terms are governed by the laws of <strong>Victoria Australia</strong>.
              </p>
            </section>

            <div className="mt-12 text-center pt-8">
              <Link 
                to="/" 
                className="text-indigo-600 font-bold hover:underline"
              >
                Return to Home
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default TermsOfUsePage;
