
import { DatabaseService } from './DatabaseService';
import { AuditLogEntry, User } from '../types';

export class AuditService {
  static async recordAction(actor: User, action: string, targetId: string, details: string): Promise<void> {
    const entry: AuditLogEntry = {
      id: 'audit-' + Math.random().toString(36).substr(2, 9),
      timestamp: Date.now(),
      actorId: actor.id,
      actorEmail: actor.email,
      action,
      targetId,
      details
    };
    await DatabaseService.put('audit', entry);
  }

  static async getLogs(): Promise<AuditLogEntry[]> {
    const logs = await DatabaseService.getAll<AuditLogEntry>('audit');
    return logs.sort((a, b) => b.timestamp - a.timestamp);
  }
}
