
import { DatabaseService } from './DatabaseService';
import { User, UserRole } from '../types';

const AUTH_KEY = 'medi8_auth_user';

export class AuthService {
  static async login(email: string): Promise<User | null> {
    const users = await DatabaseService.getAll<User>('users');
    const user = users.find(u => u.email.toLowerCase() === email.toLowerCase());
    
    // Auto-create public user if not found during demo
    if (!user && email.includes('@')) {
      const newUser: User = {
        id: 'u-' + Math.random().toString(36).substr(2, 9),
        email: email,
        role: UserRole.PUBLIC,
        displayName: email.split('@')[0]
      };
      await DatabaseService.put('users', newUser);
      this.setSession(newUser);
      return newUser;
    }

    if (user) {
      this.setSession(user);
      return user;
    }
    return null;
  }

  static logout() {
    localStorage.removeItem(AUTH_KEY);
  }

  static getCurrentUser(): User | null {
    const stored = localStorage.getItem(AUTH_KEY);
    return stored ? JSON.parse(stored) : null;
  }

  private static setSession(user: User) {
    localStorage.setItem(AUTH_KEY, JSON.stringify(user));
  }
}
