
import { DatabaseService } from './DatabaseService';
import { Enquiry } from '../types';

export class EnquiryService {
  static async createEnquiry(enquiry: Enquiry): Promise<void> {
    await DatabaseService.put('enquiries', enquiry);
  }

  static async getEnquiriesForMediator(mediatorId: string): Promise<Enquiry[]> {
    const all = await DatabaseService.getAll<Enquiry>('enquiries');
    return all.filter(e => e.mediatorId === mediatorId).sort((a, b) => b.timestamp - a.timestamp);
  }
}
