
import { FixedFeePackage } from '../types';

export const FIXED_FEE_PACKAGES: FixedFeePackage[] = [
  {
    id: 'ff-parenting-express',
    name: 'Parenting Express (Online)',
    description: 'A focused 2-hour online session for simple parenting plan updates or specific issues.',
    durationHours: 2,
    totalFeeCents: 49500,
    category: 'cat-family'
  },
  {
    id: 'ff-business-starter',
    name: 'SME Quick-Resolve',
    description: '4-hour commercial mediation for small business contract disputes.',
    durationHours: 4,
    totalFeeCents: 125000,
    category: 'cat-commercial'
  },
  {
    id: 'ff-workplace-checkin',
    name: 'Workplace Facilitation',
    description: '3-hour neutral facilitation for interpersonal workplace conflict.',
    durationHours: 3,
    totalFeeCents: 85000,
    category: 'cat-workplace'
  }
];

export class FixedFeeService {
  static getPackages(): FixedFeePackage[] {
    return FIXED_FEE_PACKAGES;
  }

  static getPackageById(id: string): FixedFeePackage | undefined {
    return FIXED_FEE_PACKAGES.find(p => p.id === id);
  }
}
